breed [ muscle-fibers muscle-fiber ]

muscle-fibers-own [
  fiber-size   ;; velikost, odlin od bnho parametru "size", nebo je vyjdena v jinch jednotkch
  max-size
]

patches-own [
  anabolic-hormone  ;; hormon podporujc rst svalovch vlken
  catabolic-hormone ;; hormon podporujc rozklad svalovch vlken
]

globals [
  muscle-mass  ;; udruje informaci o soutu velikosti vech svalovch vlken
  ;; velikosti hormon jsou pevn ohranieny, aby bylo dosaeno realistickho prosted
  anabolic-hormone-max
  anabolic-hormone-min
  catabolic-hormone-max
  catabolic-hormone-min
  ;; mra, s jakou se hormony  (rozptyluj) od jednoho vlkna k ostatnm
  hormone-diffuse-rate
]

to setup
  ca
  set-default-shape muscle-fibers "circle"
  initialize-hormones
  new-muscle-fibers
  set muscle-mass sum [fiber-size] of muscle-fibers
  do-plotting
end

to initialize-hormones
  ;; hormonln konstantny pro rst sval 
  ;; s realistickmi hodnotami
  set hormone-diffuse-rate 0.75
  ask patches [
    set anabolic-hormone-max 200
    set catabolic-hormone-max 250
    set anabolic-hormone-min 50
    set catabolic-hormone-min 52
    set anabolic-hormone 50
    set catabolic-hormone 52
  ]
  regulate-hormones
end

to new-muscle-fibers
  ask patches [
    sprout-muscle-fibers 1 [
      set max-size 4
      ;; vytvo normalizovan rozdlen maximln velikosti svalovch vlken
      ;; s medinem zvislm na hodnot %-pomalu-stahujicich-vlaken
      repeat 20  [
        if random-float 100 > %-pomalu-stahujicich-vlaken [
          set max-size max-size + 1
        ]
      ]
      ;; zabezpeuje rznorodou poten velikost jednotlivch vlken 
      set fiber-size (0.2 + random-float 0.4) * max-size
      regulate-muscle-fibers
    ]
  ]
end

to go
  ;; vimnte si vyuitho primitiva LOG v nsledujc procedue,
  ;; kter simuluje tendenci prodnch systm adaptovat se mn a mn
  ;; na kadou dal jednotku biologick substance
  perform-daily-activity
  if posilovani? and (ticks mod dny-mezi-cvicenim = 0)
    [ lift-weights ]
  sleep
  regulate-hormones
  develop-muscle
  set muscle-mass sum [fiber-size] of muscle-fibers
  tick
  do-plotting
end

to perform-daily-activity
  ;; simuluje hormonn dopady kadodennch
  ;; aktivit jako je napklad sledovn televize nebo prce
  ask muscle-fibers [
    set catabolic-hormone catabolic-hormone + 2.0 * (log fiber-size 10)
    set anabolic-hormone anabolic-hormone + 2.5 * (log fiber-size 10)
  ]
end

to lift-weights
  ;; simuluje hormonln dopad svalov zte (posilovn)
  ask muscle-fibers [
    if( random-float 1.0 < intenzita / 100 * intenzita / 100 ) [
      set anabolic-hormone anabolic-hormone + (log fiber-size 10) * 55
      set catabolic-hormone catabolic-hormone + (log fiber-size 10) * 44
    ]
  ]
end

to sleep
  ;; simuluje hormonln dopad spnku
  ask patches [
    set catabolic-hormone catabolic-hormone - 0.5 * (log catabolic-hormone 10) * hodiny-spanku
    set anabolic-hormone anabolic-hormone - 0.48 * (log anabolic-hormone 10) * hodiny-spanku
  ]
end

to develop-muscle
  ask muscle-fibers [
    grow
    regulate-muscle-fibers
  ]
end

to grow  ;; procedura elv
  ;; katabolick hormony mus svm psobenm nejdrve naruit svalov vlkna,
  ;; aby je nsledn mohly anabolick hormony poslit (zvit mnostv hmoty)
  set fiber-size (fiber-size - 0.20 * (log catabolic-hormone 10))
  set fiber-size (fiber-size + 0.20 * min (list (log anabolic-hormone 10)
                                                (1.05 * log catabolic-hormone 10)))
end

to regulate-muscle-fibers ;; procedura elv
  ;; simuluje pirozen omezen tla, urujc maximln a minimln velikost svalovch vlken
  if (fiber-size  < 1) [ set fiber-size 1 ]
  if (fiber-size > max-size) [ set fiber-size max-size ]
  set color scale-color red fiber-size (-0.5 * max-size) (3 * max-size)
  ;; uruje reln zobrazenou velikost elvy podle parametru fiber-size
  set size max list 0.2 (min list 1 (fiber-size / 20))
end

to regulate-hormones ;; procedura polek
  ;; hormony se  k sousednm vlknm 
  diffuse anabolic-hormone hormone-diffuse-rate
  diffuse catabolic-hormone hormone-diffuse-rate
  ;; pokud je v oblasti pli mnoho nebo pli mlo hormon,
  ;; pokus se tlo navrtit pvodn rovnovhu
  ask patches [
    set anabolic-hormone min (list anabolic-hormone anabolic-hormone-max)
    set anabolic-hormone max (list anabolic-hormone anabolic-hormone-min)
    set catabolic-hormone min (list catabolic-hormone catabolic-hormone-max)
    set catabolic-hormone max (list catabolic-hormone catabolic-hormone-min)
    ;; obarv polka podle koncentrace hormon
    set pcolor approximate-rgb ((catabolic-hormone / catabolic-hormone-max) * 255)
                   ((anabolic-hormone / anabolic-hormone-max)  * 255)
                   0
  ]
end

to do-plotting
  set-current-plot "Vvoj svalu"
  set-current-plot-pen "sval"
  plot muscle-mass / 100

  set-current-plot "Hormony"
  set-current-plot-pen "anabolick"
  plot mean [anabolic-hormone] of patches
  set-current-plot-pen "katabolick"
  plot mean [catabolic-hormone] of patches
end


; *** NetLogo 4.0.3 Model Copyright Notice ***
;
; This model was created as part of the projects:
; PARTICIPATORY SIMULATIONS: NETWORK-BASED DESIGN FOR SYSTEMS LEARNING IN
; CLASSROOMS and/or INTEGRATED SIMULATION AND MODELING ENVIRONMENT.
; The project gratefully acknowledges the support of the
; National Science Foundation (REPP & ROLE programs) --
; grant numbers REC #9814682 and REC-0126227.
;
; Copyright 2002 by Uri Wilensky.  All rights reserved.
;
; Permission to use, modify or redistribute this model is hereby granted,
; provided that both of the following requirements are followed:
; a) this copyright notice is included.
; b) this model will not be redistributed for profit without permission
;    from Uri Wilensky.
; Contact Uri Wilensky for appropriate licenses for redistribution for
; profit.
;
; To refer to this model in academic publications, please use:
; Wilensky, U. (2002).  NetLogo Muscle Development model.
; http://ccl.northwestern.edu/netlogo/models/MuscleDevelopment.
; Center for Connected Learning and Computer-Based Modeling,
; Northwestern University, Evanston, IL.
;
; In other publications, please use:
; Copyright 2002 Uri Wilensky.  All rights reserved.
; See http://ccl.northwestern.edu/netlogo/models/MuscleDevelopment
; for terms of use.
;
; *** End of NetLogo 4.0.3 Model Copyright Notice ***
@#$#@#$#@
GRAPHICS-WINDOW
365
10
766
432
8
8
23.0
1
10
1
1
1
0
1
1
1
-8
8
-8
8
1
1
1
ticks

CC-WINDOW
5
519
775
614
Command Center
0

BUTTON
43
22
114
55
Piprav
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
5
139
221
172
dny-mezi-cvicenim
dny-mezi-cvicenim
1
30
5
1
1
dni
HORIZONTAL

SLIDER
5
106
221
139
hodiny-spanku
hodiny-spanku
0
12
8
0.5
1
hodin
HORIZONTAL

PLOT
5
209
350
354
Vvoj svalu
as
Svalov hmota
0.0
60.0
0.0
20.0
true
false
PENS
"sval" 1.0 0 -2674135 true

PLOT
5
354
350
505
Hormony
as
Hormony
0.0
60.0
0.0
30.0
true
true
PENS
"anabolick" 1.0 0 -16777216 true
"katabolick" 1.0 0 -1184463 true

SLIDER
5
73
221
106
intenzita
intenzita
50
100
95
1
1
NIL
HORIZONTAL

BUTTON
127
22
196
55
Start
Go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

SWITCH
226
73
349
106
posilovani?
posilovani?
0
1
-1000

SLIDER
5
172
225
205
%-pomalu-stahujicich-vlaken
%-pomalu-stahujicich-vlaken
0
100
50
1
1
NIL
HORIZONTAL

@#$#@#$#@
CO TO JE?
---------

Tento model ukazuje fyziologick aspekty cvien. Jeho elem je pomoci pochopit faktory, ktermi je ovlivnna vhodn hormonln rovnovha, pi kter dochz k rstu svalstva pomoc posilovn. Tmito faktory jsou:

Frekvence - pravidelnost posilovn je jednm ze zkladnch faktor, ovlivujc prstek svalov hmoty. Pokud zatujete svaly pli asto, nebudete mt as na jejich zotaven a vybudovn silnj muskulatury. Pokud naopak neposilujete dostaten asto, nedte tm svalm dostatek stimul k dlouhodobmu prstku hmoty.

Spnek - tlo vykonv vtinu regeneranch proces v prbhu spnku. Pokud nemte dostatek spnku, nebudete tlu dvat pleitost k obnov, m zhorte podmnky pro tvorbu svalstva.

Intenzita - to, jak tvrd pracujete pi namhn sval, ovlivn, jak moc dvte zabrat vem vaim svalovm vlknm. Pi zaten velkho mnostv svalovch vlken zskte silnj rstov stimuly, pokud jim poskytnete dostatek asu k obnov.

Genetick faktory - pomr mezi pomalu se stahujcmi a rychle se stahujcmi vlkny hraje u jednotlivch lid vznamnou roli v monostech vvoje svalstva. Jedinci, kte maj vce pomalu se stahujcch svalovch vlken, budou mt vt vdr, avak maj potencil pouze k dosaen prmrn svalov hmoty. Jedinci s vtm mnostvm rychle se stahujcch vlken maj potencil rozvinout vt objemy svalov hmoty, avak s ni vdr.

Strava - patn sloen stravy me naruovat rst svalstva. V tomto modelu pedpokldme ideln skladbu stravy.

Vech tchto pt faktor je teba pochopit a stanovit mezi nimi rovnovhu za elem dosaen optimlnho rozvoje svalstva. Vhodn kombinace tchto faktor je vysoce zvisl na jednotlivci a jeho aktulnm jedinenm stavu. Ten se mn v prbhu asu. 

JAK TO FUNGUJE?
---------------

Dleit je, e inky posilovn jsou vyvolny hormonlnmi odpovmi tla. Hormony, ivotn dleit pro vvoj svalstva, lze rozdlit do dvou td: katabolick hormony a anabolick hormony. Katabolick hormony rozkldaj svalov vlkna a pipravuj je tak na jejich poslenou pestavbu pomoc anabolickch hormon. Vimnte si, e katabolick hormony hraj zsadn roli, nebo je teba svalov vlkna rozloit, ne mohou bt znovu vybudovny mohutnj.

Tento model se sna simulovat tyto inky pomoc zobrazen pnho ezu svalu na rovni jednotlivch svalovch vlken. Kdy pozorovatel aktivuje svalov vlkna pomoc zte (posilovn), vlkna vypust chemick signly, kter vedou k nrstu hladiny hormon v oblasti tohoto vlkna. Tyto hormony ovlivuj vvoj danho vlkna (jak je popsno ve) a v prbhu asu miz.

Kruhy v okn modelu reprezentuj jednotliv svalov vlkna. Jejich barevn pozad me bt chpno jako bunn tekutina, obsahujc anabolick a katabolick hormony. m je zelen barva pozad svtlej, tm je prosted vce anabolick (podporujc rst sval). m je svtlej lut barva, tm je prosted vce katabolick (svaly rozkldajc). 

JAK MODEL OVLDAT
-----------------

Tlatko PIPRAV nastav poten prosted modelu a tlatko START spust bh modelu.

Pepna POSILOVN? rozhoduje, zda sledovan subjekt aktivn posiluje i nikoliv.

Posuvnk INTENZITA zaznamenv, jak tce subjekt posiluje. m vt je intenzita trninku, tm vt je mnostv svalovch vlken, kter budou v pi kadm trninku unaveny.

Posuvnk HODINY-SPANKU ukazuje mnostv spnku dan osoby, ovlivujc, jak rychle je tlo schopno odbourat hormony.

Posuvnk DNY-MEZI-CVICENIM - pravidelnost posilovn ovlivuje, kolik asu m tlo k obnov a nrstu svalov hmoty po poslednm trninku.

Posuvnk %-POMALU-STAHUJICICH-VLAKEN udv, s jakou pravdpodobnost maj vlkna charakteristiku pomalho stahovn.

Grafy: VVOJ SVALU - souet velikosti vech svalovch vlken v ase; HORMONY - prmrn obsah hormonu kolem kadho vlkna 

VYZKOUEJTE SI
--------------

Kroky 1 a 3 si vyzkouejte s posuvnkem %-POMALU-STAHUJICICH-VLAKEN nastavenm na hodnotu 50.

1. Spuste model s pvodnm (standardnm) nastavenm. Co se pi nm dje s mnostvm svalov hmoty? Pro?

2. Pokud nem tlo dostatek zdroj k pln regeneraci z poslednho trninku ped dalm, dochz k petrnovn. V dsledku petrnovn dochz ke stagnaci vvoje svalu a v extremnch ppadech dokonce k bytku svalov hmoty. Jak podmnky mohou vst k petrnovn? Jak je nejlep zpsob regenerace z petrnovn? Jak kroky lze podniknout k vyhnut se petrnovn?

3. Mnoho lid posiluje ve snaze o dosaen maximln mon svalov hmoty. Najdte nejlep metodu k dosaen tohoto cle. Jak se pln mus mnit v prbhu asu? Pro je dleit brt v potaz aktuln kondici kadho jedince pi vbr vhodnho trninkovho programu?

4. Problmem, kter se bere mlo v potaz pi konvennm trninku, jsou genetick pedpoklady. Hlavnm faktorem je v tomto ohledu pomr mezi pomalu a rychle stahujcmi vlkny, ve kterm se jednotliv lid vznamn odliuj. Pomalu stahujc vlkna poskytuj vt vdr, zatmco rychle stahujc vlkna vt slu a celkovou velikost svalov hmoty.

Pokuste se zskat maximln monou svalovou hmotu pro hodnotu %-POMALU-STAHUJICICH-VLAKEN nastavenou nejdve na 90 % a pot na 10 %. Jak se mn dosaen vsledky s rozdlnou genetickou vbavou? Zle na metodch trninku? Co nm toto zjitn k o prmrnch lidech, vyuvajcch trninkov programy geneticky obdaench profesionlnch kulturist? 

ROZEN MODELU
----------------

1. Abyste zskali jistotu o dosaen maximlnho rozvoje svalu, pidejte do grafu Vvoj svalu dal barvu pro kivku nazvanou max-sval. Nyn upravte proceduru grafu aby vykreslovala navc max-sval jako souet hodnot MAX-SIZE vekerch svalovch vlken.

2. Kvalita stravy me mt zsadn vliv na vsledky, dosaen pomoc trninku. Upravte model pidnm tohoto faktoru. Pidejte promnnou IVINY k rodu MUSCLE-FIBER. Do uivatelskho rozhrann modelu pidejte posuvnk KVALITA-STRAVY. Nyn upravte proceduru tlatka START, aby spustila funkci ZISKAT-ZIVINY, kter by vypoutla iviny k polkm. Nakonec upravte proceduru GROW tak, aby brala v potaz dostupn iviny pi zvtovn velikosti svalovho vlkna.

3. Ve skutenm ivot dochz u prmrnch lid k ad nepravidelnost v intenzit trninkovho programu. Pidejte tedy do modelu funkci odrejc tyto nepravidelnosti, kter by nhodn generovala noci s kratm asem spnku a nebo naopak dny odpoinku. Pidejte do uivatelskho rozhrann pepna, pomoc kterho by mohl uivatel tyto nepravidelnosti zapnout a vypnout. Pidejte posuvnk uren k prav velikosti nepravidelnost. Jak inky budou mt tyto nepravidelnosti na vvoj svalstva? 

VIMNTE SI
-----------

Lidsk tlo je neuviteln komplexn systm. Pro ely simulace jeho jednotliv sti, kter ns zajm, bylo teba pevn zvolit nkter pedpoklady o chovn ostatnch st. To lze nalzt v pevnm stanoven nkterch jinak promnnch parametr, jako jsou napklad hranice hladin hormon nebo maximln velikost svalovch vlken. Tyto pevn stanoven pedpoklady nm umouj soustedit pozornost na pochopen celkovho procesu vvoje svalu bez nutnosti zabvat se vekermi detailnmi informacemi. 

PROGRAMOVAC ZAJMAVOSTI NETLOGA
--------------------------------

Vimnte si, e v je procedue NEW-MUSCLE-FIBERS pouito primitivum REPEAT a promnn %-POMALU-STAHUJICICH-VLAKEN, kter generuj normln rozdlen pro maximln velikost svalovch vlken s medinem urenm hodnotou parametru %-POMALU-STAHUJICICH-VLAKEN.

Prohldnte si tak pouit funkce LOG v procedurch, kter reguluj vypoutn hormon a jejich rovnovhu. Tato funkce nm pomh lpe napodobit sklon vech pirozench systm adaptovat se mn a mn na kadou dal jednotku dan substance.

Vimnte si pouit primitiva RGB v procedue REGULATE-HORMONES, kter obarvuje polka na zklad velikosti hladin hormon a zajiuje tak plynul vizuln pechod z anabolickho do katabolickho stavu.

PODKOVN A ODKAZY
----------------------
Pvodn implementace: Scott Styles pro isntitut Center for Connected Learning and Computer-Based Modeling.

Pi citovn tohoto modelu ve vdeckch publikacch pouijte prosm nsledujc odkaz:  Wilensky, U. (2002).  NetLogo Muscle Development model.  http://ccl.northwestern.edu/netlogo/models/MuscleDevelopment.  Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

V jinch publikacch uvete prosm tyto informace:  Copyright 2002 Uri Wilensky.  All rights reserved.  See http://ccl.northwestern.edu/netlogo/models/MuscleDevelopment for terms of use.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.0.3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
